import numpy as np
from collections import deque

class Running:
    def __init__(self, n):
        self.n = n
        self.data = deque([0.0] * n, maxlen=n)
        self.mean = self.variance = self.stddev = 0.0

    def add(self, x):
        n = self.n
        oldmean = self.mean
        goingaway = self.data[0]
        self.mean = newmean = oldmean + (x - goingaway) / n
        self.data.append(x)
        self.variance += (x - goingaway) * ((x - newmean) + (goingaway - oldmean)) / (n - 1)
        self.stddev = np.sqrt(np.maximum(self.variance, 1e-20))

class ObjDict(dict):
    def __init__(self, ins_dict=None):
        super().__init__()
        if ins_dict is not None:
            for n in ins_dict.keys(): 
                self[n] = ins_dict[n]

    def insert_dict(self, ins_dict):
        for n in ins_dict.keys(): 
            self[n] = ins_dict[n]

    def __getattr__(self, name):
        if name in self:
            return self[name]
        else:
            raise AttributeError("No such attribute: " + name)

    def __setattr__(self, name, value):
        self[name] = value

    def __delattr__(self, name):
        if name in self:
            del self[name]
        else:
            raise AttributeError("No such attribute: " + name)

def compute_proximity(targets):
    # returns the object distances between every object, as a batch size x nxn matrix
    dists = list()
    for i in range(targets.shape[1]):
        target = np.expand_dims(targets[:, i], axis=1)
        dists.append(np.linalg.norm(targets - target, axis=-1))
    return np.stack(dists, axis=1)
